import sys
import time
import os
import select
import paramiko

host = '12.97.210.126'
username = '*****'
password = '*****'
ssh = None
next_index = None





#=============
#    GUI
#============

# clears output screen and prints title
def display_title():
    os.system('cls')
    print("|=================================================================================================|")
    print("|                                                                                                 |")
    print("|  |===========================================================================================|  |")
    print("|  |   ▄████████  ▄██████▄     ▄████████     ███      ▄█  ███▄▄▄▄      ▄████████     ███       |  |")
    print("|  |  ███    ███ ███    ███   ███    ███ ▀█████████▄ ███  ███▀▀▀██▄   ███    ███ ▀█████████▄   |  |")
    print("|  |  ███    █▀  ███    ███   ███    ███    ▀███▀▀██ ███  ███   ███   ███    █▀     ▀███▀▀██   |  |")
    print("|  | ▄███▄▄▄     ███    ███  ▄███▄▄▄▄██▀     ███   ▀ ███  ███   ███  ▄███▄▄▄         ███   ▀   |  |")
    print("|  |▀▀███▀▀▀     ███    ███ ▀▀███▀▀▀▀▀       ███     ███  ███   ███ ▀▀███▀▀▀         ███       |  |")
    print("|  |  ███        ███    ███ ▀███████████     ███     ███  ███   ███   ███    █▄      ███       |  |")
    print("|  |  ███        ███    ███   ███    ███     ███     ███  ███   ███   ███    ███     ███       |  |")
    print("|  |  ███         ▀██████▀    ███    ███    ▄████▀   █▀    ▀█   █▀    ██████████    ▄████▀     |  |")
    print("|  |===========================================================================================|  |")
    print("|                               MAC Address Reservation Script                                    |")
    print("|=================================================================================================|")
    print("")
    print("")

#will print choice menu using array of choices passed and return the choice
def list_choices(choices):
    for choice in choices:
        print(str(choices.index(choice)+1)+". "+str(choice))
        print("")
    return int(input())

def main_menu():
    display_title()
    choices = ["Connect", "Exit"]
    choice = list_choices(choices)
    if choice == 1:
        display_title()
        branch = input("Enter Branch:  ")
        print(" ")
        #host = "10.10.", branch[0:1], ".254"
        connect_to_host(host, username, password)
        get_next_index()
        branch_menu()
        return
    if choice == 2:
        os.system('cls')
        return
    else:
        print("ERROR: choice out of range...")
        return

def branch_menu():
    display_title()
    print("1. Print Lease List")
    print(" ")
    print("2. Print Reservations")
    print("")
    print("3. Make Reservation")
    print(" ")
    print("4. Remove Reservation")
    print(" ")
    print("5. Edit Reservation")
    print(" ")
    print("6. Back to Main Menu")
    print(" ")
    choice = int(input())
    if choice == 1:
        print_lease_list_menu()
    elif choice == 2:
        print_reservation_menu()
    elif choice == 3:
        make_reservation_menu()
    elif choice == 4:
        delete_reservation_menu()
    elif choice == 5:
        main_menu()
    elif choice == 6:
        main_menu()
    else:
        print("ERROR: choice out of range...")
        time.sleep(1)
        return

def make_reservation_menu():
    display_title()
    print("MAKE RESERVATION")
    print("")
    mac = input("Enter MAC Address...")
    description = input("Enter Description...(if no description wanted press Enter)")
    print("")
    print("1. Dynamically Assign IP")
    print("")
    print("2. Set IP")
    print("")
    choice = int(input())
    if choice == 1:
        if description == "":
            command = """config system dhcp server
                         edit 1
                         config reserved-address
                         edit """+str(next_index)+"""
                         set mac """+str(mac)+"""
                         set action assign
                         next
                         end
                         next
                         end
                         """
        else:
            command = """config system dhcp server
                         edit 1
                         config reserved-address
                         edit """+str(next_index)+"""
                         set mac """+str(mac)+"""
                         set action assign
                         set description """+str(description)+"""
                         next
                         end
                         next
                         end
                         """
        execute_command(command)
        print("Set Reservation!!!")
        get_next_index()
        back = input("Press any key to return....")
        branch_menu()
    elif choice == 2:
        print("")
        ip = input("Enter IP...")
        if description == "":
            command = """config system dhcp server
                         edit 1
                         config reserved-address
                         edit """+str(next_index)+"""
                         set mac """+str(mac)+"""
                         set ip """+str(ip)+"""
                         next
                         end
                         next
                         end
                         """
        else:
            command = """config system dhcp server
                         edit 1
                         config reserved-address
                         edit """+str(next_index)+"""
                         set mac """+str(mac)+"""
                         set ip """+str(ip)+"""
                         set description """+str(description)+"""
                         next
                         end
                         next
                         end
                         """
        execute_command(command, True)
        print("Set Reservation!!!")
        get_next_index()
        back = input("Press any key to return....")
        branch_menu()
    else:
        print("ERROR: choice out of range...")

def delete_reservation_menu():
    display_title()
    print("DELETE RESERVATION")
    print("")
    print("Enter Index of Entry you want to Delete...")
    print("")
    choice = int(input())
    if choice < next_index:
        command = """config system dhcp server
                     edit 1
                     config reserved-address
                     delete """+str(choice)+"""
                     end
                     next
                     end
                     """
        execute_command(command)
        print("Deleted Reservation!!!")
        back = input("Press any key to return....")
        branch_menu()
    else:
        print("ERROR: index out of range...")


def print_lease_list_menu():
    display_title()
    print("LEASE LIST")
    print("")
    command = "execute dhcp lease-list"
    execute_command(command, True)
    print("press any key to return...")
    choice = input()
    branch_menu()


def print_reservation_menu():
    display_title()
    print("RESERVATIONS")
    print("")
    command = """config system dhcp server
                 edit 1
                 config reserved-address
                 sh
                 end
                 end
                 """
    execute_command(command, True)
    print("press any key to return...")
    choice = input()
    branch_menu()





#=============
#  FUNCTIONS
#============






def find_next_index():
    max = 0
    file = open('temp-reserved-address.txt', "r")
    lines = file.readlines()
    for line in lines:
        lineArr = line.split(" ")
        if 'edit' in line:
            if int(lineArr[5]) > max:
                max = int(lineArr[5])
            #print(lineArr[5])
    file.close()
    print('NEXT ENTRY INDEX: ', str(max+1))
    return max+1

def connect_to_host(host, username, password):
    global ssh
    # Try to connect to the host. Retry a few times if it fails.
    while True:
        i = 1
        try:
            ssh = paramiko.SSHClient()
            ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
            ssh.connect(host, username = username, password = password)
            print ("Connected to ", str(host))
            break
        except paramiko.AuthenticationException:
            print ("Authentication failed when connecting to ", str(host))
            sys.exit(1)
        except:
            print ("Could not SSH to ", str(host),", trying again in 2 seconds... ")
            i += 1
            time.sleep(2)
        # If we could not connect within time limit
        if i == 30:
            print ("Could not connect to ", str(host))
            sys.exit(1)

def execute_command(command, output=False):
    global ssh
    # Send the command (non-blocking)
    stdin, stdout, stderr = ssh.exec_command(command)
    file = open('temp-reserved-address.txt', "w")
    # Wait for the command to terminate
    while not stdout.channel.exit_status_ready():
        # Only print data if there is data to read in the channel
        if stdout.channel.recv_ready():
            rl, wl, xl = select.select([stdout.channel], [], [], 0.0)
            if len(rl) > 0:
                # Print data from stdout
                file.write(str(stdout.channel.recv(1024).decode("utf-8")))
    file.close()
    if output == True:
        file = open('temp-reserved-address.txt')
        lines = file.readlines()
        for line in lines:
            print(line)

def get_next_index():
    global next_index
    command = """config system dhcp server
                 edit 1
                 config reserved-address
                 sh
              """
    execute_command(command)
    next_index = find_next_index()
    print(next_index)




#Enter main loop
main_menu()
# Disconnect from the host
if ssh != None:
    print ("Closing SSH connection")
    ssh.close()
