# Auto Chlor Line MONITOR
# this program pings various IP Addresses provided and displays their ping
# related data in a GUI coded using Python and TKinter

# TODO:
#<< convert labels to labelframes and implement grid system
# add router connection label
# expand labelframe when clicked on to display realtime graph of latency and various other analytical data
# change update function so its not recursivly calling itself but rather a proper scheduled task
#
#




from tkinter import *
import os
import os.path
import subprocess
import queue
import time
import re
import sys
import threading
#import schedule
from threading import Thread
from threading import Timer
from time import sleep

#sys.setrecursionlimit(2000)
class branchObject:
    def __init__(self, branch):
        self.Branch = branch
        self.LatencyData = []
    def setIP(self, ip):
        self.IP = ip
    def setLabel(self, label):
        self.Label = label
    def setLatency(self, latency):
        self.Latency = latency
        self.latency_data(latency)
    def setBranchBar(self, branchbar):
        self.BranchBar = branchbar
    # stores latest 100 latency data
    def latency_data(self, latency):
        if len(self.LatencyData) < 100:
            self.LatencyData.append(latency)
        else:
            self.LatencyData.pop(0)
            self.LatencyData.append(latency)



# dictionary of branchObject classes
BranchStructure = {}

# replace the below 4 global dictionaries with the above class and array

# dictionary with keys being branches and values being their WAN IP
#branchIP = {}
# dictionary with keys being branches and values being their TKinter LabelFrames
#branchLabel = {}

#latency = {}

#branch_bar = {}

def onFrameConfigure(canvas):
    #Reset the scroll region to encompass the inner frame
    canvas.configure(scrollregion=canvas.bbox("all"))



def read_branches(filepath):
    #global branchIP
    file = open(filepath)
    lines = file.readlines()
    for line in lines:
        line = line.split(" ")
        #branchIP[line[0]] = line[1]
        branch_obj = branchObject(line[0])
        branch_obj.setIP(line[1])
        BranchStructure[line[0]] = branch_obj
        print(line[0], line[1])

def log_error(error):
    exists = os.path.isfile("logs/error_dump.txt")
    if exists:
        file = open("logs/error_dump.txt", "a")
    else:
        file = open("logs/error_dump.txt", "w")
    ts = time.localtime()
    timestamp = time.strftime("%x %X", ts)
    file.write(timestamp+":     "+error)
    file.close()

def log_raw_data(branch, raw_data):
    exists = os.path.isfile("logs/raw_data.txt")
    if exists:
        file = open("logs/raw_data.txt", "a")
    else:
        file = open("logs/raw_data.txt", "w")
    file.write("BRANCH:"+branch+":  "+str(raw_data)+'\n')
    file.close()

def log_ping_data(branch, output):
    output = str(output)
    exists = os.path.isfile("logs/"+str(branch)+".txt")
    if exists:
        file = open("logs/"+str(branch)+".txt", "a")
    else:
        file = open("logs/"+str(branch)+".txt", "w")
    ts = time.localtime()
    timestamp = time.strftime("%x %X", ts)
    if output.find("Reply") != -1:
        a = output.find("time")
        pingtime = output[a + 5:]
        pingtime = pingtime.split()
        pingtime = pingtime[0]
        pingtime = pingtime[:-2]
        writeLine = timestamp+" SUCCESS "+pingtime+"ms"
    else:
        writeLine = timestamp+" FAIL 0ms"
    file.write(writeLine+"\n")
    file.close()

def get_pingtime(branch):
    file = open("logs/"+str(branch)+".txt", "r")
    lines = file.readlines()
    line_length = len(lines)
    most_recent_line = lines[line_length-1]
    most_recent_line = most_recent_line.split(" ")
    pingtime = most_recent_line[3]
    pingtime = pingtime[:-3]
    #print(branch+":   "+pingtime+"ms")
    if pingtime.isdigit():
        return int(pingtime)
    else:
        log_error("get_pingtime() returned ["+str(pingtime)+"] instead of an integer")
        print("ERROR LOGGED!!!")
        return 0


def get_ping_bar(time):
    if time == 0:
        return ">>|"
    barlength = 5
    bar = ">>"
    for x in range(time, -1, -barlength):
        bar += "="
    bar += "|"
    return bar

def callback(event):
    print ("clicked at", event.x, event.y)


class RepeatedTimer(object):
    def __init__(self, interval, function, *args, **kwargs):
        self._timer     = None
        self.interval   = interval
        self.function   = function
        self.args       = args
        self.kwargs     = kwargs
        self.is_running = False
        self.start()

    def _run(self):
        self.is_running = False
        self.start()
        self.function(*self.args, **self.kwargs)

    def start(self):
        if not self.is_running:
            self._timer = Timer(self.interval, self._run)
            self._timer.start()
            self.is_running = True

    def stop(self):
        self._timer.cancel()
        self.is_running = False


class GUI:
    # ...
    def __init__(self, master):
        #global branchLabel
        self.master = master
        read_branches("branchList.txt")
        bg_color = "#91FFFF"
        font = "arial 10 bold"
        for key, value in BranchStructure.items():
            print("packed")
            self.labelframe = LabelFrame(frame, bg=bg_color, bd=0,borderwidth=0)
            self.labelframe.pack_propagate(0)
            self.labelframe.pack(fill=BOTH, expand=0)
            self.branchlabel = Label(self.labelframe, bg=bg_color, text=str(key) + ":", width=7, font=font, anchor=W).grid(column=0, row=0,padx=(15, 0))
            latency_var = StringVar()
            latency_var.set("")
            #latency[str(key)] = latency_var
            BranchStructure[str(key)].setLatency(latency_var)
            self.latency = Label(self.labelframe, bg=bg_color, textvariable=latency_var, font=font, width=9).grid(column=1,row=0,padx=(0, 0))
            bar_var = StringVar()
            bar_var.set("")
            #branch_bar[str(key)] = bar_var
            BranchStructure[str(key)].setBranchBar(bar_var)
            self.bar = Label(self.labelframe, bg=bg_color, textvariable=bar_var, width=90, font=font,anchor=W).grid(column=2, row=0, padx=(40, 0))
            #branchLabel[str(key)] = self.labelframe
            BranchStructure[str(key)].setLabel(self.labelframe)
            ThreadedTask(master, key).start()
            if bg_color == "#91FFFF":
                bg_color = "white"
            else:
                bg_color = "#91FFFF"
            #master.update()
        sheduler = RepeatedTimer(1, self.update)


    def update(self):
        print("==========UPDATING MONITOR==========")
        #global branchLabel
        #global latency
        #global branch_bar
        for key, value in BranchStructure.items():
            pingtime = get_pingtime(key)
            pingbar = get_ping_bar(int(pingtime))
            #latency[str(key)].set(str(pingtime)+"ms")
            BranchStructure[str(key)].Latency.set(str(pingtime)+"ms")
            #branch_bar[str(key)].set(pingbar)
            BranchStructure[str(key)].BranchBar.set(pingbar)
            #branchLabel[str(key)].pack()
            BranchStructure[str(key)].Label.pack()
            self.master.update()



class ThreadedTask(threading.Thread):
    # ...
    def __init__(self, master, branch):
        self.branch = str(branch)
        self.master = master
        threading.Thread.__init__(self)
        sheduler = RepeatedTimer(3, self.run)

    def run(self):
        global branchLabel
        pingresult = subprocess.Popen('ping -n 1 ' + BranchStructure[self.branch].IP, stdout=subprocess.PIPE, shell=True)
        status = pingresult.wait()
        (output, err) = pingresult.communicate()
        if err != None:
            print("ERROR: "+err)
        if status == 0:
            print("THREAD:"+str(self.branch)+"    SUCCESS")
        else:
            print("THREAD:"+str(self.branch)+"    FAIL")
        log_ping_data(self.branch, output)
        log_raw_data(self.branch, output)



root = Tk()
root.iconbitmap('ac.ico')
root.title('Auto-Chlor Line Monitor')
root.geometry("800x1000")
header = Label(root, bg="gray", fg="white", text="   Branch       Latency(ms)            0                                100                                200                                300                                400                       ROUTER", font="arial 10 bold",anchor=W,justify=LEFT)
header.pack(fill='both')

canvas = Canvas(root, borderwidth=0, background="#ffffff")
frame = Frame(canvas, background="#ffffff")
vsb = Scrollbar(root, orient="vertical", command=canvas.yview)
canvas.configure(yscrollcommand=vsb.set)

vsb.pack(side="right", fill="y")
canvas.pack(side="left", fill="both", expand=True)
canvas.create_window((4,4), window=frame, anchor="nw")

frame.bind("<Configure>", lambda event, canvas=canvas: onFrameConfigure(canvas))



read_branches("branchList.txt")
main_ui = GUI(frame)
print("going to update")

root.mainloop()
