from tkinter import *
import os
import subprocess
import queue
import time
import re
import threading
from threading import Thread
from time import sleep



class PingerThread(threading.Thread):

    def __init__(self):
        threading.Thread.__init__(self)
        self.queue = queue

    def run(self):
        time.sleep(5)  # Simulate long running process
        self.queue.put("Task finished")



def hello():
    print ("hello!")
def about():
    window = Toplevel(root)
    window.iconbitmap('ac.ico')
    ProgramName = Label(window, text="Auto-Chlor Line Monitor", font="arial 10 bold")
    ProgramName.pack(side=TOP)
    versionNumber = Label(window, text="V 1.0",font = "fixedsys 12 bold ")
    versionNumber.pack(side=TOP)
    abouttext1 = Label(window, text="Software used to monitor status of branches public IP and router status",font = "Times 12")
    abouttext1.pack(side=TOP)
    abouttext2 = Label(window, text="Developed using Python and Tkinter library", font = "Times 12")
    abouttext2.pack(side=TOP)
    signature = Label(window, text="Jasmit Kakkar - Junior Network Engineer", font = "arial 10 italic")
    signature.pack(side=TOP)

def readSettings():
    global refreshTime
    global logFilepath
    file = open("settings.txt", 'r')
    for line in file.readlines():
        values = line.split()
        if values[0] == "refresh":
            refreshTime = values[1]
        if values[0] == "logFilepath":
            logFilepath = values[1]
    file.close()

#def log(branch, output):


def settings():
    window = Toplevel(root)
    window.iconbitmap('ac.ico')
    window.geometry("300x300")
    #ProgramName = Label(window, text="SETTINGS", font="arial 10 bold")
    #ProgramName.pack()
    labelframe = LabelFrame(window)
    labelframe.pack()
    logsfilepath = Label(labelframe, text="Logs Filepath")
    logsfilepath.pack()
    e1 = Entry(labelframe)
    e1.insert(END, logFilepath)
    e1.pack()

    labelframe1 = LabelFrame(window)
    labelframe1.pack()
    refreshtime = Label(labelframe, text="Refresh Time (s)")
    refreshtime.pack()
    e2 = Entry(labelframe)
    e2.insert(END, refreshTime)
    e2.pack()
    def applysettings():
        logFilepath = e1
        refreshTime = e2
    apply = Button(window, text="Apply", command=applysettings)
    apply.pack()



def drawMenu(root):
    menubar = Menu(root)


    # create more pulldown menus
    optionsmenu = Menu(menubar, tearoff=0)
    optionsmenu.add_command(label="Settings", command=settings)
    optionsmenu.add_command(label="Exit", command=hello)
    menubar.add_cascade(label="Options", menu=optionsmenu)

    statisticsmenu = Menu(menubar, tearoff=0)
    statisticsmenu.add_command(label="110", command=about)
    statisticsmenu.add_command(label="120", command=about)
    statisticsmenu.add_command(label="130", command=about)
    statisticsmenu.add_command(label="140", command=about)
    statisticsmenu.add_command(label="...", command=about)
    menubar.add_cascade(label="Statistics", menu=statisticsmenu)

    logmenu = Menu(menubar, tearoff=0)
    logmenu.add_command(label="110", command=about)
    logmenu.add_command(label="120", command=about)
    logmenu.add_command(label="130", command=about)
    logmenu.add_command(label="140", command=about)
    logmenu.add_command(label="...", command=about)
    menubar.add_cascade(label="Logs", menu=logmenu)

    helpmenu = Menu(menubar, tearoff=0)
    helpmenu.add_command(label="About", command=about)
    menubar.add_cascade(label="Help", menu=helpmenu)

    # display the menu
    root.config(menu=menubar)

def onFrameConfigure(canvas):
    #Reset the scroll region to encompass the inner frame
    canvas.configure(scrollregion=canvas.bbox("all"))
def readBranches(filepath):
    file = open(filepath, 'r')
    branchList = {}
    for line in file.readlines():
        values = line.split()
        branchList[values[0]] = values[1]
    file.close()
    return branchList

def threaded_pingBranch(branch, wanIP):
    global framecolor
    #if branch in labelDictionary:
        #labelDictionary[branch].destroy()
    pingresult = subprocess.Popen('ping -n 1 ' + wanIP, stdout=subprocess.PIPE, shell=True)
    (output, err) = pingresult.communicate()
    status = pingresult.wait()

    routerIP = "10.10." + branch[:-1] + ".254"
    # routerresult = subprocess.Popen('ping -n 1 ' + routerIP, stdout=subprocess.PIPE, shell=True)
    # routerresult.wait()
    # routeroutput = routerresult.poll()
    routeroutput = 1

    #print(branch, ": ", output)


    printline = extractData(branch, output)
    if branch in labelDictionary:
        labelframe = labelDictionary[branch]
    else:
        labelframe = LabelFrame(frame, bg=framecolor, height=10)
        labelframe.pack_propagate(0)
        labelframe.pack(fill=BOTH, expand=0)
    branchlabel = Label(labelframe, bg=framecolor, text=branch + ":", width=7, font="arial 10 bold", anchor=W).grid(column=0, row=0,padx=(15, 0))
    latency = Label(labelframe, bg=framecolor, text=getTime(output, 1), font="arial 10 bold", width=9).grid(column=1,row=0,padx=(0, 0))
    bar = Label(labelframe, bg=framecolor, text=drawBar(int(getTime(output, 0))), width=90, font="arial 10 bold",anchor=W).grid(column=2, row=0, padx=(40, 0))

    if routeroutput == 1:
        router = Label(labelframe, bg=framecolor, image=greenImage, width=150, anchor=W).grid(column=3, row=0)
    else:
        router = Label(labelframe, bg=framecolor, image=redImage, width=10, anchor=W).grid(column=3, row=0)

    if framecolor == "#91FFFF":
        framecolor = "white"
    else:
        framecolor = "#91FFFF"
    labelDictionary[str(branch)] = labelframe
    frame.update()
    #sleep(1)



def pingBranches(branchList):
    for x in range(0,100):
        for key, value in branchList.items():
            thread = Thread(target=threaded_pingBranch(key, value))
            thread.start()
            #thread.join()
            #threaded_pingBranch(key, value)
            print(key,"thread started...")
        #sleep(refreshTime)
        print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
        print("                 UPDATING MONITOR                   ")
        print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")

#returns latency from raw ping output data,
#outputType = 1      this will return the latency in string formatting
#outputType = 0      this will return the latency in integer formatting
def getTime(output, outputType):
    output = str(output)
    if output.find("Request timed out") != -1:
        if outputType == 1:
            return "TIMEOUT"
        else:
            return 0
    a = output.find("time")
    time = output[a + 5:]
    time = time.split()
    time = time[0]
    time = time[:-2]
    if outputType == 1:
        return str(time)+"ms"
    else:
        return time

def extractData(branch, output):
    output = str(output)
    a = output.find("time")

    pingtime = output[a + 5:]
    pingtime = pingtime.split()
    pingtime = pingtime[0]
    pingtime = pingtime[:-2]

    printline = "     "+branch + ":                  " + pingtime
    if output.find("Request timed out") != -1:
        printline = "     "+branch + ":                  "+"TIMEOUT"
    else:
        bar = drawBar(int(pingtime))
        printline = printline + bar
    routerstatus = 1
    return printline

def drawBar(time):
    if time == 0:
        return ">>|"
    barlength = 5
    bar = ">>"
    for x in range(time, -1, -barlength):
        bar += "="
    bar += "|"
    return bar

def drawRouters(status):
    if status == 0:
        green = Label(routerList, image = greenImage)
        green.pack()
    else:
        red = Label(routerList, image=redImage)
        red.pack()






root = Tk()
root.iconbitmap('ac.ico')
root.title('Auto-Chlor Line Monitor')
#root.geometry("1100x950")
root.geometry("1100x800")


drawMenu(root)

header = Label(root, bg="gray", fg="white", text="   Branch       Latency(ms)            0                                100                                200                                300                                400                       ROUTER", font="arial 10 bold",anchor=W,justify=LEFT)
header.pack(fill='both')

greenImage = PhotoImage(file="green.gif")
redImage = PhotoImage(file="red.gif")
filepath = "branchList.txt"
framecolor = "#91FFFF"
labelDictionary = {}
settingsFilepath = "settings.txt"
logFilepath = "\\logs"
refreshTime = 300
readSettings()

threads = []

canvas = Canvas(root, borderwidth=0, background="#ffffff")
frame = Frame(canvas, background="#ffffff")
vsb = Scrollbar(root, orient="vertical", command=canvas.yview)
canvas.configure(yscrollcommand=vsb.set)

vsb.pack(side="right", fill="y")
canvas.pack(side="left", fill="both", expand=True)
canvas.create_window((4,4), window=frame, anchor="nw")

frame.bind("<Configure>", lambda event, canvas=canvas: onFrameConfigure(canvas))

branchList = readBranches(filepath)
pingBranches(branchList)
root.mainloop()
