import queue
import os
import subprocess
import re
import threading
import time
from tkinter import *
from tkinter import ttk


branches = {}

def read_branches(filepath):
    branchList = {}
    file = open(filepath)
    lines = file.readlines()
    for line in lines:
        line = line.split(" ")
        branchList[line[0]] = line[1]
        print(line[0], line[1])
    return branchList

class GUI:
    # ...
    def __init__(self, master):
        global branches
        self.master = master
        branchList = read_branches("branchList.txt")
        for key, value in branchList.items():
            print("packed")
            self.labelframe = LabelFrame(master, height=40)
            branches[key] = self.labelframe
            self.labelframe.pack_propagate(0)
            self.labelframe.pack(fill=BOTH, expand=0)
            self.label = Label(self.labelframe, text=str(key) + ":", width=7, font="arial 10 bold", anchor=W)
            self.label.pack()
            #self.labelframe.pack(side=TOP)
        #self.test_button = Button(self.master, command=self.tb_click)
        #self.test_button.configure(
        #    text="Start", background="Grey",
        #    padx=50
        #)
        #self.test_button.pack(side=TOP)

    def progress(self):
        self.prog_bar = ttk.Progressbar(
            self.master, orient="horizontal",
            length=200, mode="indeterminate"
        )
        self.prog_bar.pack(side=TOP)
        self.prog_bar.start()
    def tb_click(self):
        self.progress()
        #self.prog_bar.start()
        self.queue = queue.Queue()
        ThreadedTask(self.queue).start()
        self.master.after(100, self.process_queue())

    def process_queue(self):
        try:
            msg = self.queue.get(0)
            print(msg)
            # Show result of the task if needed
            #self.prog_bar.stop()
        except queue.Empty:
            self.master.after(100, self.process_queue)

class ThreadedTask(threading.Thread):
    def __init__(self, queue):
        threading.Thread.__init__(self)
        self.queue = queue
    def run(self):
        time.sleep(5)  # Simulate long running process
        self.queue.put("Task finished")

root = Tk()
root.iconbitmap('ac.ico')
root.title('Auto-Chlor Line Monitor')
#root.geometry("1100x950")
root.geometry("1100x800")
read_branches("branchList.txt")
main_ui = GUI(root)
root.mainloop()
